<!doctype html>
<html lang="en">
<!-- [Head] start -->

<head>
    <title>Phoenix Admin</title>
    <!-- [Meta] -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="description" content="" />
    <meta name="author" content="" />

    <!-- [Favicon] icon -->
    <link rel="icon" href="<?php echo e(asset('/admin/')); ?>/assets/images/favicon.svg" type="image/x-icon" />
    <!-- [Google Font : Public Sans] icon -->
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:wght@400;500;600;700&display=swap"
        rel="stylesheet" />
    <!-- [phosphor Icons] https://phosphoricons.com/ -->
    <link rel="stylesheet" href="<?php echo e(asset('/admin/')); ?>/assets/fonts/phosphor/duotone/style.css" />
    <!-- [Tabler Icons] https://tablericons.com -->
    <link rel="stylesheet" href="<?php echo e(asset('/admin/')); ?>/assets/fonts/tabler-icons.min.css" />
    <!-- [Feather Icons] https://feathericons.com -->
    <link rel="stylesheet" href="<?php echo e(asset('/admin/')); ?>/assets/fonts/feather.css" />
    <!-- [Font Awesome Icons] https://fontawesome.com/icons -->
    <link rel="stylesheet" href="<?php echo e(asset('/admin/')); ?>/assets/fonts/fontawesome.css" />
    <!-- [Material Icons] https://fonts.google.com/icons -->
    <link rel="stylesheet" href="<?php echo e(asset('/admin/')); ?>/assets/fonts/material.css" />
    <!-- [Template CSS Files] -->
    <link rel="stylesheet" href="<?php echo e(asset('/admin/')); ?>/assets/css/style.css" id="main-style-link" />
    <link rel="stylesheet" href="<?php echo e(asset('/admin/')); ?>/assets/css/style-preset.css" />

</head>
<!-- [Head] end -->
<!-- [Body] Start -->

<body data-pc-preset="preset-1" data-pc-sidebar-theme="light" data-pc-sidebar-caption="true" data-pc-direction="ltr"
    data-pc-theme="light">
    <!-- [ Pre-loader ] start -->
    <div class="loader-bg">
        <div class="loader-track">
            <div class="loader-fill"></div>
        </div>
    </div>
    <!-- [ Pre-loader ] End -->

    <div class="auth-main v2">
        <div class="bg-overlay bg-dark"></div>
        <div class="auth-wrapper">
            <div class="auth-sidecontent">
                <div class="auth-sidefooter">

                    <hr class="mb-3 mt-4" />
                    <div class="row">
                        <div class="col my-1">
                            <p class="m-0">Admin Auth</p>
                        </div>

                    </div>
                </div>
            </div>
            <div class="auth-form">
                <div class="card my-5 mx-3" style="min-height: auto;">
                    <form class="card-body" action="" method="POST">
                        <?php echo e(csrf_field()); ?>

                        <div class="text-center">
                            <img src="<?php echo e(asset('/admin/')); ?>/assets/images/authentication/img-auth-login.png"
                                alt="images" class="img-fluid mb-3" width="100">
                        </div>
                        <h4 class="f-w-500 mb-3">Login with your email</h4>

                        <div class="form-group">
                            <?php echo $__env->make('layouts/flash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <div class="mb-3">
                            <input type="email" name="email" class="form-control" id="floatingInput"
                                placeholder="Email Address" value="<?php echo e(old('email')); ?>" />
                        </div>
                        <div class="mb-3">
                            <input type="password" name="password" class="form-control" id="floatingInput1"
                                placeholder="Password" />
                        </div>

                        <div class="d-grid mt-4">
                            <button type="submit" name="login" class="btn btn-primary">Login</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- [ Main Content ] end -->
    <!-- Required Js -->
    <script src="<?php echo e(asset('/admin/')); ?>/assets/js/plugins/popper.min.js"></script>
    <script src="<?php echo e(asset('/admin/')); ?>/assets/js/plugins/simplebar.min.js"></script>
    <script src="<?php echo e(asset('/admin/')); ?>/assets/js/plugins/bootstrap.min.js"></script>
    <script src="<?php echo e(asset('/admin/')); ?>/assets/js/plugins/i18next.min.js"></script>
    <script src="<?php echo e(asset('/admin/')); ?>/assets/js/plugins/i18nextHttpBackend.min.js"></script>
    <script src="<?php echo e(asset('/admin/')); ?>/assets/js/icon/custom-font.js"></script>
    <script src="<?php echo e(asset('/admin/')); ?>/assets/js/script.js"></script>
    <script src="<?php echo e(asset('/admin/')); ?>/assets/js/theme.js"></script>
    <script src="<?php echo e(asset('/admin/')); ?>/assets/js/multi-lang.js"></script>
    <script src="<?php echo e(asset('/admin/')); ?>/assets/js/plugins/feather.min.js"></script>


    <script>
        layout_change('light');
    </script>

    <script>
        layout_sidebar_change('light');
    </script>

    <script>
        change_box_container('false');
    </script>

    <script>
        layout_caption_change('true');
    </script>

    <script>
        layout_rtl_change('false');
    </script>

    <script>
        preset_change('preset-1');
    </script>


</body>
<!-- [Body] end -->

</html>
<?php /**PATH /home/nlgasisc/phoenixfundlimited.com/port/resources/views/auth/admin_login.blade.php ENDPATH**/ ?>