<?php

use App\Http\Controllers\Web\Current\{WebHookController, ScriptController};
use App\Http\Controllers\Api\Current\TesterController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Web\Current\Admin\{AuthController};

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::any('/', [TesterController::class, 'index'])->name('hold');
Route::any("/webhook/cryptomus", [WebHookController::class, 'cryptomus'])->name("webhook.cryptomus");
Route::any("/webhook/nowpayments", [WebHookController::class, 'nowpayments'])->name("webhook.nowpayments");

Route::any("/autopay/deposit/verify/{uuid}", [ScriptController::class, 'verify_auto_pay'])->name("verify.autopay");
Route::any("/autopay/nowpayments/success/{uuid}", [ScriptController::class, 'verify_auto_pay'])->name("nowpayments.success");
Route::any("/autopay/nowpayments/cancel/{uuid}", [ScriptController::class, 'verify_auto_pay'])->name("nowpayments.cancel");

$admin = "vice";
Route::any("/$admin/login", [AuthController::class, 'login'])->name("admin.login");

Route::get('/', function () {
    exit();
});

Route::get('/tester/pa', [TesterController::class, 'tester_pa']);


Route::prefix($admin)
    ->name('admin.')
    ->namespace('App\Http\Controllers\Web\Current\Admin')
    ->group(function () {
        Route::middleware('admin')->group(__DIR__ . '/admin.php');
    });
