<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Current\{
    AuthController,
    UserController,
    UtilsController,
    TradeController
};

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

$version = 'v1';

Route::post("$version/login", [AuthController::class, 'login']);
Route::post("$version/quick-login", [AuthController::class, 'quick_login']);
Route::post("$version/verify-2fa", [AuthController::class, 'verify_2fa']);

Route::post("$version/register/", [AuthController::class, 'register']);

Route::post("$version/forgot-password", [AuthController::class, 'forgot_password']);
Route::post("$version/reset-password", [AuthController::class, 'reset_password']);

Route::group(['prefix' => $version, 'middleware' => ['auth:sanctum']], function () {
    
    Route::post("place-trade", [TradeController::class, 'place_trade']);
    Route::post("close-trade", [TradeController::class, 'close_trade']);
    Route::post("update-asset", [TradeController::class, 'update_asset']);
    
    Route::get('get/all-markets', [TradeController::class, 'get_all_markets']);
    Route::get('get/all-plans', [UtilsController::class, 'plans']);
    Route::get('get/all-assets', [TradeController::class, 'get_all_assets']);
    Route::get('get/auto/deposit-coins', [UtilsController::class, 'get_deposit_coins']);
    Route::get('get/deposit-gateway', [UtilsController::class, 'get_deposit_gateway']);

    Route::get("user/refresh", [UserController::class, 'user']);
    Route::post("user/2fa/set", [UserController::class, 'set_2fa_type']);
    Route::post("user/2fa/activate-google", [UserController::class, 'activate_google_2fa']);
    Route::get("user/get/history/trades", [UserController::class, 'trade_history']);
    Route::get("user/get/history/copiedtrades/{username}", [UserController::class, 'get_copied_trades']);
    Route::get("trader/history/transactions/{trader_id}", [UserController::class, 'trader_transaction_history']);
    Route::get("trader/history/trades/{trader_id}", [UserController::class, 'trader_trade_history']);
    Route::get("user/get/deposit-auto/verify/{uuid}", [UserController::class, 'verify_auto']);
    Route::get("user/get/tradebots", [UserController::class, 'get_user_trade_bots']);
    Route::get("user/get/toptraders", [UserController::class, 'get_user_toptraders']);
    Route::get("user/get/settings/withdrawal", [UserController::class, 'get_withdrawal_settings']);
    Route::get("user/get/deposit-payment-settings", [UserController::class, 'get_deposit_payment_settings']);

    Route::post("user/withdraw", [UserController::class, 'withdraw']);
    Route::post("user/start-copy", [UserController::class, 'start_copy']);
    Route::post("user/stop-copy", [UserController::class, 'stop_copy']);
    Route::post("user/deposit-manual", [UserController::class, 'upload_deposit_manual']);
    Route::post("user/deposit-auto", [UserController::class, 'deposit_auto']);
    Route::post("user/update-profile", [UserController::class, 'update_profile']);
    Route::post("user/update-picture", [UserController::class, 'update_picture']);
    Route::post("user/upload-id", [UserController::class, 'upload_id']);
    Route::post("user/change-password", [UserController::class, 'update_password']);
    Route::post("user/set-crypto-withdrawal-settings", [UserController::class, 'set_crypto_withdrawal_settings']);
    Route::post("user/delete-crypto-withdrawal-settings", [UserController::class, 'delete_crypto_withdrawal_settings']);
    
});