<!doctype html>
<html lang="en">
<!-- [Head] start -->

<head>
    <title> {{ $page_title ?? '' }} | Blue Chip Growth Fund Admin</title>
    <!-- [Meta] -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="description" content="" />

    <!-- [Favicon] icon -->
    <link rel="icon" href="{{ asset('/fav.png') }}" type="image/png" />

    <!-- map-vector css -->
    <link rel="stylesheet" href="{{ asset('/admin') }}/assets/css/plugins/jsvectormap.min.css" />
    <!-- [Google Font : Public Sans] icon -->
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:wght@400;500;600;700&display=swap"
        rel="stylesheet" />
    <!-- [phosphor Icons] https://phosphoricons.com/ -->
    <link rel="stylesheet" href="{{ asset('/admin') }}/assets/fonts/phosphor/duotone/style.css" />
    <!-- [Tabler Icons] https://tablericons.com -->
    <link rel="stylesheet" href="{{ asset('/admin') }}/assets/fonts/tabler-icons.min.css" />
    <!-- [Feather Icons] https://feathericons.com -->
    <link rel="stylesheet" href="{{ asset('/admin') }}/assets/fonts/feather.css" />
    <!-- [Font Awesome Icons] https://fontawesome.com/icons -->
    <link rel="stylesheet" href="{{ asset('/admin') }}/assets/fonts/fontawesome.css" />
    <!-- [Material Icons] https://fonts.google.com/icons -->
    <link rel="stylesheet" href="{{ asset('/admin') }}/assets/fonts/material.css" />
    <!-- [Template CSS Files] -->
    <link rel="stylesheet" href="{{ asset('/admin') }}/assets/css/style.css" id="main-style-link" />
    <link rel="stylesheet" href="{{ asset('/admin') }}/assets/css/style-preset.css" />
    <!-- data tables css -->
    <link rel="stylesheet" href="{{ asset('/admin') }}/assets/css/plugins/dataTables.bootstrap5.min.css" />

    <!-- [Page Specific JS] start -->
    <script src="{{ asset('/admin') }}/assets/js/plugins/apexcharts.min.js"></script>
    <script src="{{ asset('/admin') }}/assets/js/plugins/jsvectormap.min.js"></script>
    <script src="{{ asset('/admin') }}/assets/js/plugins/world.js"></script>
    <script src="{{ asset('/admin') }}/assets/js/plugins/world-merc.js"></script>
    <script src="{{ asset('/admin') }}/assets/js/widgets/earnings-users-chart.js"></script>
    <script src="{{ asset('/admin') }}/assets/js/widgets/world-map-markers.js"></script>
    <!--  -->
    <!-- [Page Specific JS] end -->
    <!-- Required Js -->
    <script src="{{ asset('/admin') }}/assets/js/plugins/popper.min.js"></script>
    <script src="{{ asset('/admin') }}/assets/js/plugins/simplebar.min.js"></script>
    <script src="{{ asset('/admin') }}/assets/js/plugins/bootstrap.min.js"></script>
    <script src="{{ asset('/admin') }}/assets/js/plugins/i18next.min.js"></script>
    <script src="{{ asset('/admin') }}/assets/js/plugins/i18nextHttpBackend.min.js"></script>
    <script src="{{ asset('/admin') }}/assets/js/icon/custom-font.js"></script>
    <script src="{{ asset('/admin') }}/assets/js/script.js"></script>
    <script src="{{ asset('/admin') }}/assets/js/theme.js"></script>
    <script src="{{ asset('/admin') }}/assets/js/multi-lang.js"></script>
    <script src="{{ asset('/admin') }}/assets/js/plugins/feather.min.js"></script>

    <!-- datatable Js -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="{{ asset('/admin') }}/assets/js/plugins/dataTables.min.js"></script>
    <script src="{{ asset('/admin') }}/assets/js/plugins/dataTables.bootstrap5.min.js"></script>


    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2/dist/css/select2.min.css" rel="stylesheet">

    <!-- Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2/dist/js/select2.min.js"></script>


    <style>
        .form-group {
            margin-bottom: 20px;
        }

        .select2-dropdown {
            z-index: 1083 !important;
        }

        .select2-container {
            width: 100% !important;
        }

        /* Style the Select2 container to look like a Bootstrap input */
        .select2-container .select2-selection--single {
            height: calc(2.25rem + 2px);
            padding: 0.375rem 0.75rem;
            border: 1px solid #ced4da;
            border-radius: 0.375rem;
        }
    </style>
</head>
<!-- [Head] end -->
<!-- [Body] Start -->

<body data-pc-preset="preset-2" data-pc-sidebar-theme="light" data-pc-sidebar-caption="true" data-pc-direction="ltr"
    data-pc-theme="light">
    <!-- [ Pre-loader ] start -->
    <div class="loader-bg">
        <div class="loader-track">
            <div class="loader-fill"></div>
        </div>
    </div>
    <!-- [ Pre-loader ] End -->
    <!-- [ Sidebar Menu ] start -->
    <nav class="pc-sidebar">
        <div class="navbar-wrapper">
            <div class="m-header">
                <a href="{{ route('admin.dashboard') }}" class="b-brand text-primary">
                    <!-- ========   Change your logo from here   ============ -->
                    <img src="{{ asset('/logo-dark.png') }}" alt="" class="logo-lsg" width="100" />
                    <span class="badge bg-brand-color-2 rounded-pill ms-1 theme-version">v1.0.0</span>
                </a>
            </div>
            <div class="navbar-content">
                <ul class="pc-navbar">

                    <li class="pc-item pc-caption">
                        <label data-i18n="Navigation">Navigation</label>
                        <i class="ph-duotone ph-table"></i>
                    </li>

                    <li class="pc-item">
                        <a href="{{ route('admin.dashboard') }}" class="pc-link">
                            <span class="pc-micon">
                                <i class="ph-duotone ph-house"></i>
                            </span>
                            <span class="pc-mtext">Dashboard</span>
                        </a>
                    </li>

                    <li class="pc-item">
                        <a href="{{ route('admin.user') }}" class="pc-link">
                            <span class="pc-micon">
                                <i class="ph-duotone ph-users"></i>
                            </span>
                            <span class="pc-mtext">User Accounts</span>
                        </a>
                    </li>

                    <li class="pc-item">
                        <a href="{{ route('admin.deposit') }}" class="pc-link">
                            <span class="pc-micon">
                                <i class="ph-duotone ph-circle"></i>
                            </span>
                            <span class="pc-mtext">Deposits</span>
                        </a>
                    </li>

                    <li class="pc-item">
                        <a href="{{ route('admin.trade') }}" class="pc-link">
                            <span class="pc-micon">
                                <i class="ph-duotone ph-chart-line-up"></i>
                            </span>
                            <span class="pc-mtext">Trades</span>
                        </a>
                    </li>

                    <li class="pc-item">
                        <a href="{{ route('admin.withdrawal') }}" class="pc-link">
                            <span class="pc-micon">
                                <i class="ph-duotone ph-circle"></i>
                            </span>
                            <span class="pc-mtext">Withdrawals</span>
                        </a>
                    </li>

                    <li class="pc-item">
                        <a href="{{ route('admin.asset') }}" class="pc-link">
                            <span class="pc-micon">
                                <i class="ph-duotone ph-circle"></i>
                            </span>
                            <span class="pc-mtext">Markets & Assets</span>
                        </a>
                    </li>

                    <li class="pc-item">
                        <a href="{{ route('admin.tradebot') }}" class="pc-link">
                            <span class="pc-micon">
                                <i class="ph-duotone ph-circle"></i>
                            </span>
                            <span class="pc-mtext">Trade Bots</span>
                        </a>
                    </li>

                    <li class="pc-item">
                        <a href="{{ route('admin.toptrader') }}" class="pc-link">
                            <span class="pc-micon">
                                <i class="ph-duotone ph-circle"></i>
                            </span>
                            <span class="pc-mtext">Top Traders</span>
                        </a>
                    </li>

                    {{-- <li class="pc-item">
                        <a href="{{ route('admin.dashboard') }}" class="pc-link">
                            <span class="pc-micon">
                                <i class="ph-duotone ph-ticket"></i>
                            </span>
                            <span class="pc-mtext">Tickets</span>
                        </a>
                    </li> --}}

                    {{-- <li class="pc-item">
                        <a href="{{ route('admin.dashboard') }}" class="pc-link">
                            <span class="pc-micon">
                                <i class="ph-duotone ph-user-circle-gear"></i>
                            </span>
                            <span class="pc-mtext">Staffs</span>
                        </a>
                    </li> --}}

                    <li class="pc-item pc-hasmenu">
                        <a href="#" class="pc-link">
                            <span class="pc-micon">
                                <i class="ph-duotone ph-gear"></i>
                            </span>
                            <span class="pc-mtext">Settings</span><span class="pc-arrow"><i
                                    data-feather="chevron-right"></i></span></a>
                        <ul class="pc-submenu">
                            <li class="pc-item"><a class="pc-link" href="{{ route('admin.plan') }}">Plans</a></li>
                            <li class="pc-item"><a class="pc-link" href="{{ route('admin.setting') }}">Settings</a></li>
                            <li class="pc-item"><a class="pc-link" href="{{ route('admin.setting.payment') }}">Auto Deposit Settings</a></li>
                            <li class="pc-item"><a class="pc-link" href="{{ route('admin.setting.crypto', 0) }}">Manual Crypto Deposit Settings</a></li>
                        </ul>
                    </li>

                    <li class="pc-item">
                        <a href="{{ route('admin.login') }}" class="pc-link">
                            <span class="pc-micon">
                                <i class="ph-duotone ph-power"></i>
                            </span>
                            <span class="pc-mtext">Log Out</span>
                        </a>
                    </li>

                </ul>
                <div class="card nav-action-card bg-brand-color-4">
                    <div class="card-body" style="background-image: url('../assets/images/layout/nav-card-bg.svg')">
                        <h5 class="text-dark">Help Center</h5>
                        <p class="text-dark text-opacity-75">Please contact us for more questions.</p>
                        <a href="/" class="btn btn-primary" target="_blank">Go to
                            help Center</a>
                    </div>
                </div>
            </div>
            <div class="card pc-user-card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <img src="{{ asset('/admin') }}/assets/images/user/avatar-1.jpg" alt="user-image"
                                class="user-avtar wid-45 rounded-circle" />
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <div class="dropdown">
                                <a class="arrow-none dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"
                                    data-bs-offset="0,20">
                                    <div class="d-flex align-items-center">
                                        <div class="flex-grow-1 me-2">
                                            <h6 class="mb-0">Super Admin</h6>
                                            <small>Administrator</small>
                                        </div>
                                        <div class="flex-shrink-0">
                                            <div class="btn btn-icon btn-link-secondary avtar">
                                                <i class="ph-duotone ph-windows-logo"></i>
                                            </div>
                                        </div>
                                    </div>
                                </a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </nav>
    <!-- [ Sidebar Menu ] end -->
    <!-- [ Header Topbar ] start -->
    <header class="pc-header">
        <div class="header-wrapper"> <!-- [Mobile Media Block] start -->
            <div class="me-auto pc-mob-drp">
                <ul class="list-unstyled">
                    <!-- ======= Menu collapse Icon ===== -->
                    <li class="pc-h-item pc-sidebar-collapse">
                        <a href="#" class="pc-head-link ms-0" id="sidebar-hide">
                            <i class="ti ti-menu-2"></i>
                        </a>
                    </li>
                    <li class="pc-h-item pc-sidebar-popup">
                        <a href="#" class="pc-head-link ms-0" id="mobile-collapse">
                            <i class="ti ti-menu-2"></i>
                        </a>
                    </li>

                </ul>
            </div>
            <!-- [Mobile Media Block end] -->
            <div class="ms-auto">
                <ul class="list-unstyled">

                    <li class="dropdown pc-h-item d-none d-md-inline-flex">
                        <a class="pc-head-link dropdown-toggle arrow-none me-0" data-bs-toggle="dropdown"
                            href="index.html#" role="button" aria-haspopup="false" aria-expanded="false">
                            <i class="ph-duotone ph-sun-dim"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-end pc-h-dropdown">
                            <a class="dropdown-item" onclick="layout_change('dark')">
                                <i class="ph-duotone ph-moon"></i>
                                <span>Dark</span>
                            </a>
                            <a class="dropdown-item" onclick="layout_change('light')">
                                <i class="ph-duotone ph-sun-dim"></i>
                                <span>Light</span>
                            </a>
                            <a class="dropdown-item" onclick="layout_change_default()">
                                <i class="ph-duotone ph-cpu"></i>
                                <span>Default</span>
                            </a>
                        </div>
                    </li>

                    <li class="dropdown pc-h-item">
                        <a class="pc-head-link dropdown-toggle arrow-none me-0" data-bs-toggle="dropdown"
                            href="index.html#" role="button" aria-haspopup="false" aria-expanded="false">
                            <i class="ph-duotone ph-bell"></i>
                            <span class="badge bg-success pc-h-badge">0</span>
                        </a>
                        <div class="dropdown-menu dropdown-notification dropdown-menu-end pc-h-dropdown">
                            <div class="dropdown-header d-flex align-items-center justify-content-between">
                                <h5 class="m-0">Notifications</h5>
                                <ul class="list-inline ms-auto mb-0">
                                    {{-- <li class="list-inline-item">
                                        <a href="{{ asset('/admin') }}/application/mail.html"
                                            class="avtar avtar-s btn-link-hover-primary">
                                            <i class="ti ti-link f-18"></i>
                                        </a>
                                    </li> --}}
                                </ul>
                            </div>
                            <div class="dropdown-body text-wrap header-notification-scroll position-relative"
                                style="max-height: calc(100vh - 235px)">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item">
                                        <p class="text-span">No Notifications</p>

                                    </li>

                                </ul>
                            </div>
                            <div class="dropdown-footer">
                                <div class="row g-3">
                                    <div class="col-6">
                                        <div class="d-grid"><button class="btn btn-primary">Delete all</button></div>
                                    </div>
                                    <div class="col-6">
                                        <div class="d-grid"><button class="btn btn-outline-secondary">Mark all as
                                                read</button></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="dropdown pc-h-item header-user-profile">
                        <a class="pc-head-link dropdown-toggle arrow-none me-0" data-bs-toggle="dropdown"
                            href="index.html#" role="button" aria-haspopup="false" data-bs-auto-close="outside"
                            aria-expanded="false">
                            <img src="{{ asset('/admin') }}/assets/images/user/avatar-2.jpg" alt="user-image"
                                class="user-avtar" />
                        </a>
                        <div class="dropdown-menu dropdown-user-profile dropdown-menu-end pc-h-dropdown">
                            <div class="dropdown-header d-flex align-items-center justify-content-between">
                                <h5 class="m-0">Profile</h5>
                            </div>
                            <div class="dropdown-body">
                                <div class="profile-notification-scroll position-relative"
                                    style="max-height: calc(100vh - 225px)">
                                    <ul class="list-group list-group-flush w-100">
                                        <li class="list-group-item">
                                            <div class="d-flex align-items-center">
                                                <div class="flex-shrink-0">
                                                    <img src="{{ asset('/admin') }}/assets/images/user/avatar-2.jpg"
                                                        alt="user-image" class="wid-50 rounded-circle" />
                                                </div>
                                                <div class="flex-grow-1 mx-3">
                                                    <h5 class="mb-0">Super Admin</h5>
                                                    {{-- <a class="link-primary"
                                                        href="mailto:carson.darrin@company.io">carson.darrin@company.io</a> --}}
                                                </div>
                                                <span class="badge bg-primary">PRO</span>
                                            </div>
                                        </li>

                                        <li class="list-group-item">
                                            {{-- <a href="index.html#" class="dropdown-item">
                                                <span class="d-flex align-items-center">
                                                    <i class="ph-duotone ph-plus-circle"></i>
                                                    <span>Add account</span>
                                                </span>
                                            </a> --}}
                                            <a href="{{ route('admin.login') }}" class="dropdown-item">
                                                <span class="d-flex align-items-center">
                                                    <i class="ph-duotone ph-power"></i>
                                                    <span>Logout</span>
                                                </span>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </header>
    <!-- [ Header ] end -->

    <!-- [ Main Content ] start -->
    <div class="pc-container">
        <div class="pc-content">


            @yield('content')

        </div>
    </div>
    <!-- [ Main Content ] end -->


    <footer class="pc-footer">
        <div class="footer-wrapper container-fluid">
            <div class="row">
                <div class="col-sm-6 my-1">
                    <p class="m-0">Blue Chip Growth Fund</p>
                </div>
                <div class="col-sm-6 ms-auto my-1">
                    <ul class="list-inline footer-link mb-0 justify-content-sm-end d-flex">

                    </ul>
                </div>
            </div>
        </div>
    </footer>
    <div class="offcanvas border-0 pct-offcanvas offcanvas-end" tabindex="-1" id="offcanvas_pc_layout">
        <div class="offcanvas-header justify-content-between">
            <h5 class="offcanvas-title">Settings</h5>
            <button type="button" class="btn btn-icon btn-link-danger" data-bs-dismiss="offcanvas"
                aria-label="Close"><i class="ti ti-x"></i></button>
        </div>
        <div class="pct-body customizer-body">
            <div class="offcanvas-body py-0">
                <ul class="list-group list-group-flush">
                    <li class="list-group-item">
                        <div class="pc-dark">
                            <h6 class="mb-1">Theme Mode</h6>
                            <p class="text-muted text-sm">Choose light or dark mode or Auto</p>
                            <div class="row theme-color theme-layout">
                                <div class="col-4">
                                    <div class="d-grid">
                                        <button class="preset-btn btn active" data-value="true"
                                            onclick="layout_change('light');">
                                            <span class="btn-label">Light</span>
                                            <span
                                                class="pc-lay-icon"><span></span><span></span><span></span><span></span></span>
                                        </button>
                                    </div>
                                </div>
                                <div class="col-4">
                                    <div class="d-grid">
                                        <button class="preset-btn btn" data-value="false"
                                            onclick="layout_change('dark');">
                                            <span class="btn-label">Dark</span>
                                            <span
                                                class="pc-lay-icon"><span></span><span></span><span></span><span></span></span>
                                        </button>
                                    </div>
                                </div>
                                <div class="col-4">
                                    <div class="d-grid">
                                        <button class="preset-btn btn" data-value="default"
                                            onclick="layout_change_default();" data-bs-toggle="tooltip"
                                            title="Automatically sets the theme based on user's operating system's color scheme.">
                                            <span class="btn-label">Default</span>
                                            <span class="pc-lay-icon d-flex align-items-center justify-content-center">
                                                <i class="ph-duotone ph-cpu"></i>
                                            </span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="list-group-item pc-sidebar-color">
                        <h6 class="mb-1">Sidebar Theme</h6>
                        <p class="text-muted text-sm">Choose Sidebar Theme</p>
                        <div class="row theme-color theme-sidebar-color">
                            <div class="col-6">
                                <div class="d-grid">
                                    <button class="preset-btn btn" data-value="true"
                                        onclick="layout_sidebar_change('dark');">
                                        <span class="btn-label">Dark</span>
                                        <span
                                            class="pc-lay-icon"><span></span><span></span><span></span><span></span></span>
                                    </button>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="d-grid">
                                    <button class="preset-btn btn active" data-value="false"
                                        onclick="layout_sidebar_change('light');">
                                        <span class="btn-label">Light</span>
                                        <span
                                            class="pc-lay-icon"><span></span><span></span><span></span><span></span></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="list-group-item">
                        <h6 class="mb-1">Accent color</h6>
                        <p class="text-muted text-sm">Choose your primary theme color</p>
                        <div class="theme-color preset-color">
                            <a href="index.html#!" class="active" data-value="preset-1"><i
                                    class="ti ti-check"></i></a>
                            <a href="index.html#!" data-value="preset-2"><i class="ti ti-check"></i></a>
                            <a href="index.html#!" data-value="preset-3"><i class="ti ti-check"></i></a>
                            <a href="index.html#!" data-value="preset-4"><i class="ti ti-check"></i></a>
                            <a href="index.html#!" data-value="preset-5"><i class="ti ti-check"></i></a>
                            <a href="index.html#!" data-value="preset-6"><i class="ti ti-check"></i></a>
                            <a href="index.html#!" data-value="preset-7"><i class="ti ti-check"></i></a>
                            <a href="index.html#!" data-value="preset-8"><i class="ti ti-check"></i></a>
                            <a href="index.html#!" data-value="preset-9"><i class="ti ti-check"></i></a>
                            <a href="index.html#!" data-value="preset-10"><i class="ti ti-check"></i></a>
                        </div>
                    </li>
                    <li class="list-group-item">
                        <h6 class="mb-1">Sidebar Caption</h6>
                        <p class="text-muted text-sm">Sidebar Caption Hide/Show</p>
                        <div class="row theme-color theme-nav-caption">
                            <div class="col-6">
                                <div class="d-grid">
                                    <button class="preset-btn btn active" data-value="true"
                                        onclick="layout_caption_change('true');">
                                        <span class="btn-label">Caption Show</span>
                                        <span
                                            class="pc-lay-icon"><span></span><span></span><span><span></span><span></span></span><span></span></span>
                                    </button>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="d-grid">
                                    <button class="preset-btn btn" data-value="false"
                                        onclick="layout_caption_change('false');">
                                        <span class="btn-label">Caption Hide</span>
                                        <span
                                            class="pc-lay-icon"><span></span><span></span><span><span></span><span></span></span><span></span></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="list-group-item">
                        <div class="pc-rtl">
                            <h6 class="mb-1">Theme Layout</h6>
                            <p class="text-muted text-sm">LTR/RTL</p>
                            <div class="row theme-color theme-direction">
                                <div class="col-6">
                                    <div class="d-grid">
                                        <button class="preset-btn btn active" data-value="false"
                                            onclick="layout_rtl_change('false');">
                                            <span class="btn-label">LTR</span>
                                            <span
                                                class="pc-lay-icon"><span></span><span></span><span></span><span></span></span>
                                        </button>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="d-grid">
                                        <button class="preset-btn btn" data-value="true"
                                            onclick="layout_rtl_change('true');">
                                            <span class="btn-label">RTL</span>
                                            <span
                                                class="pc-lay-icon"><span></span><span></span><span></span><span></span></span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="list-group-item pc-box-width">
                        <div class="pc-container-width">
                            <h6 class="mb-1">Layout Width</h6>
                            <p class="text-muted text-sm">Choose Full or Container Layout</p>
                            <div class="row theme-color theme-container">
                                <div class="col-6">
                                    <div class="d-grid">
                                        <button class="preset-btn btn active" data-value="false"
                                            onclick="change_box_container('false')">
                                            <span class="btn-label">Full Width</span>
                                            <span
                                                class="pc-lay-icon"><span></span><span></span><span></span><span><span></span></span></span>
                                        </button>
                                    </div>
                                </div>
                                <div class="col-6">
                                    <div class="d-grid">
                                        <button class="preset-btn btn" data-value="true"
                                            onclick="change_box_container('true')">
                                            <span class="btn-label">Fixed Width</span>
                                            <span
                                                class="pc-lay-icon"><span></span><span></span><span></span><span><span></span></span></span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </li>
                    <li class="list-group-item">
                        <div class="d-grid">
                            <button class="btn btn-light-danger" id="layoutreset">Reset Layout</button>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </div>


    <script>
        $.fn.digits = function() {
            return this.each(function() {
                $(this).text($(this).text().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,"));
            })
        };

        $(".digits").digits();
    </script>

    <script>
        layout_change('light');
    </script>

    <script>
        layout_sidebar_change('light');
    </script>

    <script>
        change_box_container('false');
    </script>

    <script>
        layout_caption_change('true');
    </script>

    <script>
        layout_rtl_change('false');
    </script>

    <script>
        preset_change('preset-1');

        function handleOverflowForAllTables() {
            $('.myTable').each(function() {
                const rows = $(this).find('tbody tr');

                // Remove old overflow rows before recreating
                $(this).find('.overflow-row').remove();

                rows.each(function() {
                    const cells = $(this).find('td').slice(1); // Exclude toggle button column
                    const overflowContent = cells.slice(2).map(function() {
                        const columnName = $(this).closest('table').find('th').eq($(this).index())
                            .text();
                        const cellClassName = $(this)[0]?.className;
                        return `<p style='font-size: 12px;'><strong>${columnName}:</strong> <span class='${cellClassName}'>${$(this).html()}</span></p>`;
                    }).get().join('');

                    if (overflowContent) {
                        $(this).after(`
                            <tr class="overflow-row" style="display:none;">
                                <td colspan="${cells.length + 1}" class="overflow-content">
                                ${overflowContent}
                                </td>
                            </tr>
                        `);
                    }
                });
            });
        }

        function bindToggleEvents() {
            // Remove existing event listeners to prevent duplicates
            $('.toggle-btn').off('click').on('click', function() {
                const overflowRow = $(this).closest('tr').next('.overflow-row');
                const isVisible = overflowRow.is(':visible');
                overflowRow.toggle(!isVisible);
                $(this).text(isVisible ? '+' : '−');
            });
        }

        function handleOverflowForAllTablesCustom(id) {
            $(`.${id}`).each(function() {
                const rows = $(this).find('tbody tr');

                // Remove old overflow rows before recreating
                $(this).find('.overflow-row').remove();

                rows.each(function() {
                    const cells = $(this).find('td').slice(1); // Exclude toggle button column
                    const overflowContent = cells.slice(2).map(function() {
                        const columnName = $(this).closest('table').find('th').eq($(this).index())
                            .text();
                        const cellClassName = $(this)[0]?.className;
                        return `<p style='font-size: 12px;'><strong>${columnName}:</strong> <span class='${cellClassName}'>${$(this).html()}</span></p>`;
                    }).get().join('');

                    if (overflowContent) {
                        $(this).after(`
                            <tr class="overflow-row" style="display:none;">
                                <td colspan="${cells.length + 1}" class="overflow-content">
                                ${overflowContent}
                                </td>
                            </tr>
                        `);
                    }
                });
            });
        }

        function bindToggleEventsCustom(id) {
            // Remove existing event listeners to prevent duplicates
            $(`.${id}`).off('click').on('click', function() {
                const overflowRow = $(this).closest('tr').next('.overflow-row');
                const isVisible = overflowRow.is(':visible');
                overflowRow.toggle(!isVisible);
                $(this).text(isVisible ? '+' : '−');
            });
        }

        $(document).ready(function() {
            $('.searchableSelect').select2({
                // dropdownParent: $('.modal-dialog'),
                placeholder: "Search and select an option",
                // allowClear: true
            });

            $("* [type='submit']").on('click', function(e) {
                $(this).text('Loading...');
                $(this).hide();
            });
        });
    </script>

    @yield('add_js')

    <script></script>

</body>
<!-- [Body] end -->

</html>
