@extends('layouts.admin')
@section('add_js')
    <script type="text/javascript">
        $('#ast-dt').DataTable({
            drawCallback: function() {
                $("* .editBtn").on("click", function(e) {
                    e.preventDefault();
                    try {
                        var d = $(this).data('all');
                        const modal = new bootstrap.Modal(document.getElementById(
                            'editModal'));

                        $("#editModal [name='bot_id']").val(d.id);
                        $("#editModal [name='name']").val(d.name);
                        $("#editModal [name='details']").val(d.details);
                        $("#editModal .modal-title").text("Edit Bot: " + d.uuid);

                        modal.show();
                    } catch (err) {
                        alert(err);
                    }
                });

                $("* .deleteBtn").on("click", function(e) {
                    e.preventDefault();
                    try {
                        var d = $(this).data('all');
                        const modal = new bootstrap.Modal(document.getElementById(
                            'deleteModal'));

                        $("#deleteModal [name='bot_id']").val(d.id);
                        $("#deleteModal .modal-title").text("Delete Bot: " + d.uuid
                            .toUpperCase());

                        modal.show();
                    } catch (err) {
                        alert(err);
                    }
                });

                handleOverflowForAllTables();
                bindToggleEvents();

            }
        });
    </script>
@endsection
@section('content')
    <style>

    </style>
    <!-- [ Main Content ] start -->
    <div class="row">

        <div class="col-md-12">
            @include('layouts/flash')
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header d-flex align-items-center justify-content-between py-3">
                        <h5>Create Trade Bot</h5>
                        <div class="dropdown">

                        </div>
                    </div>
                    <div class="card-body">
                        <form action="" method="POST" autocomplete="off" enctype="multipart/form-data">
                            {{ csrf_field() }}
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <div class="form-group">
                                        <label>Name</label>
                                        <input type="text" name="name" class="form-control">
                                    </div>
                                </div>

                                <div class="col-md-12 mb-3">
                                    <div class="form-group">
                                        <label>Details</label>
                                        <textarea name="details" class="form-control"></textarea>
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label>Picture</label>
                                        <input type="file" name="avatar" class="form-control">
                                    </div>
                                </div>

                                <div class="col-md-12 mt-3">
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-primary" name="create_bot">Create</button>
                                    </div>
                                </div>

                        </form>

                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-12">


            <div class="card table-card">
                <div class="card-header d-flex align-items-center justify-content-between py-3">
                    <h5>All Trade Bots ({{ $bots->count() }})</h5>
                    <div class="dropdown">

                    </div>
                </div>
                <div class="card-body table-responsive py-3 px-4">
                    <table id="ast-dt" class="myTable table table-hover table-bordered table-sm nowrap mb-4 mt-3">
                        <thead>
                            <tr class="border-bottom-secondary border-top-1" style="font-size: 11px!important;">
                                <th scope="col">S/N</th>
                                <th scope="col"></th>
                                <th scope="col"></th>
                                <th scope="col">Name</th>
                                <th scope="col">Details</th>
                                <th scope="col">Avatar</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($bots as $r)
                                <tr class="" style="font-size: 12px;">
                                    <td>
                                        {{ $loop->iteration }}
                                    </td>
                                    <td>
                                        {{-- {{ $loop->iteration }} --}}
                                        <button class="btn btn-dark btn-sm toggle-btn"
                                            style="padding-top: 0px; padding-bottom: 0px;">+</button>
                                    </td>

                                    <td style="">

                                        <button class="btn btn-default btn-sm dropdown-toggle" type="button"
                                            data-bs-toggle="dropdown" aria-haspopup="true"
                                            aria-expanded="false">Actions</button>
                                        <div class="dropdown-menu" style="">
                                            <a class="dropdown-item editBtn" data-all="{{ json_encode($r) }}">Edit
                                            </a>

                                            <a class="dropdown-item deleteBtn"
                                                data-all="{{ json_encode(['id' => $r->id, 'uuid' => $r->uuid]) }}">
                                                Delete</a>
                                        </div>

                                    </td>

                                    <td class="">{{ $r->name }}</td>
                                    <td class="">{!! $r->details_html !!}</td>
                                    <td class="">
                                        <a href="{{ $r->avatar_url }}" target="_blank">
                                            <img src="{{ $r->avatar_url }}" width="50" alt="">
                                        </a>
                                    </td>
                                </tr>
                            @endforeach

                        </tbody>
                    </table>
                </div>


            </div>
        </div>
    </div>

    <div id="deleteModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Asset</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}

                            <div class="form-group mb-3">
                                <p class="">Are you sure?</p>
                                <input type="hidden" name="bot_id" class="">
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="delete_bot">Delete</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="editModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Bot</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}

                            <div class="col-md-12 mb-3">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input type="text" name="name" class="form-control">
                                    <input type="hidden" name="bot_id" class="">
                                </div>
                            </div>

                            <div class="col-md-12 mb-3">
                                <div class="form-group">
                                    <label>Details</label>
                                    <textarea name="details" class="form-control"></textarea>
                                </div>
                            </div>

                            <div class="col-md-12 mb-3">
                                <div class="form-group">
                                    <label>Picture</label>
                                    <input type="file" name="avatar" class="form-control">
                                </div>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="edit_bot">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

@endsection
