@extends('layouts.admin')
@section('add_js')
    <script type="text/javascript">
        $('#ast-dt').DataTable({
            drawCallback: function() {
                $("* .editBtn").on("click", function(e) {
                    e.preventDefault();
                    try {
                        var d = $(this).data('all');
                        const modal = new bootstrap.Modal(document.getElementById('editModal'));

                        $("#editModal [name='c_id']").val(d.id);
                        $("#editModal [name='market']").val(d.market);
                        $("#editModal [name='base_symbol']").val(d.base_symbol);
                        $("#editModal [name='quote_symbol']").val(d.quote_symbol);
                        $("#editModal [name='current_price']").val(d.current);
                        $("#editModal .modal-title").text("Edit Asset: " + d.symbol);

                        modal.show();
                    } catch (err) {
                        alert(err);
                    }
                });

                $("* .deleteBtn").on("click", function(e) {
                    e.preventDefault();
                    try {
                        var d = $(this).data('all');
                        const modal = new bootstrap.Modal(document.getElementById('deleteAssetModal'));

                        $("#deleteAssetModal [name='c_id']").val(d.id);
                        $("#deleteAssetModal .modal-title").text("Delete Asset: " + d.symbol
                            .toUpperCase());

                        modal.show();
                    } catch (err) {
                        alert(err);
                    }
                });

            }
        });
    </script>
@endsection
@section('content')
<style>
    .asset-img {
        position: relative;
        width: 40px;
        height: 40px;
        padding-top: 10px;
    }

    .asset-img img:nth-child(1){
        position: absolute;
        width: 22px;
        height: 22px;
        border-radius: 50%;
        top: 10px;
        z-index: 10;
    }

    .asset-img img:nth-child(2){
        position: absolute;
        width: 22px;
        height: 22px;
        border-radius: 50%;
        top: 2px;
        left: 25px;
    }
</style>
    <!-- [ Main Content ] start -->
    <div class="row">

        <div class="col-md-12 mb-3">
            {{-- <button type="button" class="btn btn-danger btn-sm">Add Market</button> --}}
            <button type="button" class="btn btn-dark btn-sm" data-bs-toggle="modal" data-bs-target="#addAssetModal">Add
                Asset</button>
        </div>

        <div class="col-md-12">
            @include('layouts/flash')
        </div>

        <div class="col-md-12">
            <div class="card table-card">
                <div class="card-header d-flex align-items-center justify-content-between py-3">
                    <h5>All Assets</h5>
                    <div class="dropdown">

                    </div>
                </div>
                <div class="card-body py-3 px-4">
                    <div class="table-responsive">
                        <table id="ast-dt" class="table table-hover table-bordered table-sm nowrap mb-4 mt-3">
                            <thead>
                                <tr class="border-bottom-secondary border-top-1">
                                    <th scope="col">S/N</th>
                                    <th scope="col"></th>
                                    <th scope="col">Symbol</th>
                                    <th scope="col">Market</th>
                                    <th scope="col">Current</th>
                                    <th scope="col">Image</th>

                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($assets as $r)
                                    <tr class="" style="font-size: 13px;">
                                        <td>{{ $loop->iteration }}</td>

                                        <td style="">

                                            <button class="btn btn-default btn-sm dropdown-toggle" type="button"
                                                data-bs-toggle="dropdown" aria-haspopup="true"
                                                aria-expanded="false">Actions</button>
                                            <div class="dropdown-menu" style="">
                                                <a class="dropdown-item editBtn" data-all="{{ json_encode($r) }}">Edit
                                                </a>

                                                <a class="dropdown-item deleteBtn"
                                                    data-all="{{ json_encode(['id' => $r->id, 'symbol' => $r->symbol]) }}">
                                                    Delete</a>
                                            </div>

                                        </td>

                                        <td class="uppercase">{{ $r->symbol }}</td>
                                        <td>{{ $r->market }}</td>
                                        <td>{{ $r->current }}</td>
                                        <td class="asset-img">
                                            @if ($r->base_image_url)
                                                <img src="{{ $r->base_image_url }}" alt="" class=""
                                                    width="30">
                                            @endif
                                            @if ($r->quote_image_url)
                                                <img src="{{ $r->quote_image_url }}" alt="" class=""
                                                    width="30">
                                            @endif
                                        </td>

                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>


            </div>
        </div>
    </div>

    <div id="addAssetModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New Asset</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST" enctype="multipart/form-data">
                            {{ csrf_field() }}

                            <div class="row">
                                <div class="form-group col-md-6  mb-3">
                                    <label>Base Symbol *</label>
                                    <input type="text" class="form-control" name="base_symbol"
                                        value="{{ old('base_symbol') }}">
                                </div>

                                <div class="form-group col-md-6  mb-3">
                                    <label>Quote Symbol *</label>
                                    <input type="text" class="form-control" name="quote_symbol"
                                        value="{{ old('quote_symbol') }}">
                                </div>
                            </div>

                            <div class="row">

                                <div class="form-group col-md-6  mb-3">
                                    <label>Market *</label>
                                    <select class="form-control" name="market">
                                        <option></option>
                                        @foreach ($markets as $r)
                                            <option value="{{ strtolower($r->name) }}">{{ strtolower($r->name) }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group col-md-6  mb-3">
                                    <label>Current Price *</label>
                                    <input type="text" class="form-control" name="current_price"
                                        value="{{ old('current_price') }}">
                                </div>

                            </div>

                            <div class="row">
                                <div class="form-group col-md-6 mb-3">
                                    <label>Base Image</label>
                                    <input type="file" name="base_image" class="form-control">
                                </div>

                                <div class="form-group col-md-6 mb-3">
                                    <label>Quote Image</label>
                                    <input type="file" name="quote_image" class="form-control">
                                </div>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-dark" name="create_asset">Submit</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="editModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit Asset</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST" enctype="multipart/form-data">
                            {{ csrf_field() }}

                            <div class="row">
                                <div class="form-group col-md-6  mb-3">
                                    <label>Base Symbol *</label>
                                    <input type="text" class="form-control" name="base_symbol" value="">
                                    <input type="hidden" name="c_id" value="">
                                </div>

                                <div class="form-group col-md-6  mb-3">
                                    <label>Quote Symbol *</label>
                                    <input type="text" class="form-control" name="quote_symbol" value="">
                                </div>
                            </div>

                            <div class="row">

                                <div class="form-group col-md-6  mb-3">
                                    <label>Market *</label>
                                    <select class="form-control" name="market">
                                        <option></option>
                                        @foreach ($markets as $r)
                                            <option value="{{ strtolower($r->name) }}">{{ strtolower($r->name) }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group col-md-6  mb-3">
                                    <label>Current Price *</label>
                                    <input type="text" class="form-control" name="current_price" value="">
                                </div>

                            </div>

                            <div class="row">
                                <div class="form-group col-md-6 mb-3">
                                    <label>Base Image</label>
                                    <input type="file" name="base_image" class="form-control">
                                </div>

                                <div class="form-group col-md-6 mb-3">
                                    <label>Quote Image</label>
                                    <input type="file" name="quote_image" class="form-control">
                                </div>
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-dark" name="edit_asset">Update</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>

    <div id="deleteAssetModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Asset</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <form action="" method="POST">
                            {{ csrf_field() }}

                            <div class="form-group mb-3">
                                <p class="">Are you sure?</p>
                                <input type="hidden" name="c_id" class="form-control">
                            </div>

                            <div class="form-group">
                                <button type="submit" class="btn btn-danger" name="delete_asset">Delete</button>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                </div>
            </div>
        </div>
    </div>
@endsection
