<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rider_kits', function (Blueprint $table) {
            $table->id();
            $table->foreignId("rider_id");
            $table->foreignId("staff_id");
            $table->string("name");
            $table->bigInteger("amount")->default(0);
            $table->integer("is_active")->default(1);
            $table->bigInteger("debit_percentage")->default(0);
            $table->dateTime("created_at")->nullable();
            $table->dateTime("updated_at")->nullable();
            $table->dateTime("deleted_at")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rider_kits');
    }
};
