<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('campaigns', function (Blueprint $table) {
            $table->id();
            $table->string("uuid");
            $table->foreignId("staff_id");
            $table->string("name");
            $table->string("channel"); //app_notification, push_notification, all
            $table->string("rule"); //e.g all_users, all_riders, all_not_paid_users, all_not_deposit_users
            $table->integer("total_rows")->default(0);
            $table->integer("total_done")->default(0);
            $table->text("title")->nullable();
            $table->text("message")->nullable();
            $table->string("image")->nullable();
            $table->string("delivery_time")->nullable();
            $table->integer("is_done")->default(0);
            $table->dateTime("created_at")->nullable();
            $table->dateTime("updated_at")->nullable();
            $table->dateTime("deleted_at")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('campaigns');
    }
};
