<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tickets', function (Blueprint $table) {
            $table->id();
            $table->string("uuid");
            $table->foreignId("staff_id");
            $table->string("title")->nullable();
            $table->text("message")->nullable();
            $table->string("image")->nullable();
            $table->string("attached_to")->nullable();
            $table->foreignId("attached_to_id")->nullable();
            $table->string("status")->default('pending');
            $table->integer("is_open")->default(1);
            $table->integer("rating")->default(0);
            $table->dateTime("created_at")->nullable();
            $table->dateTime("updated_at")->nullable();
            $table->dateTime("deleted_at")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tickets');
    }
};
