<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rider_payouts', function (Blueprint $table) {
            $table->id();
            $table->string("uuid");
            $table->foreignId("rider_id");
            $table->bigInteger("amount");
            $table->string("bank_code");
            $table->string("bank_name");
            $table->string("account_name");
            $table->string("account_number");
            $table->string("note")->nullable();
            $table->string("gateway_type")->nullable(); // paystack | flutterwave | manual
            $table->string("gateway_reference")->nullable();
            $table->string("is_done")->default(0);
            $table->dateTime("created_at")->nullable();
            $table->dateTime("updated_at")->nullable();
            $table->dateTime("deleted_at")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rider_payouts');
    }
};
