<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('app_notifications_read', function (Blueprint $table) {
            $table->id();
            $table->string("sent_to"); //rider | user | staff | all_staff | all_user | all_rider
            $table->string("type")->nullable(); // notification, push-notification
            $table->foreignId("notification_id");
            $table->foreignId("sent_to_id");
            $table->dateTime("created_at")->nullable();
            $table->dateTime("updated_at")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users_notifications');
    }
};
