<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('trips', function (Blueprint $table) {
            $table->id();
            $table->string("uuid");
            $table->foreignId("user_id");
            $table->foreignId("rider_id")->nullable();
            $table->foreignId("vehicle_id")->nullable();
            $table->longText("origin")->nullable();
            $table->longText("destination")->nullable();
            $table->longText("rider_location")->nullable();
            $table->string("distance");
            $table->integer("price_per_km");
            $table->bigInteger("total_amount");
            $table->bigInteger("amount");
            $table->bigInteger("fee");
            $table->integer("fee_percentage")->default(0);
            $table->integer("trip_rating")->default(0);
            $table->string("trip_type")->default('ride'); //ride or package
            $table->string("trip_method")->default('bike'); //bike | keke
            $table->longText("cancel_payload")->nullable();
            $table->string("payment_method")->nullable();
            $table->string("delivery_code")->nullable();
            $table->integer("is_paid")->default(0);
            $table->integer("is_done")->default(0);
            $table->string("status")->nullable();
            $table->foreignId("handled_by")->nullable(); //staff id
            $table->dateTime("handled_at")->nullable();
            $table->dateTime("start_at")->nullable();
            $table->dateTime("end_at")->nullable();
            $table->dateTime("created_at")->nullable();
            $table->dateTime("updated_at")->nullable();
            $table->dateTime("deleted_at")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('trips');
    }
};
