<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('documents_configs', function (Blueprint $table) {
            $table->id();
            $table->string("type"); //bike, user, rider
            $table->string("name");
            $table->string("field_title")->nullable();
            $table->integer("has_upload")->default(0);
            $table->integer("has_field")->default(0);
            $table->integer("has_two_sides_image")->default(0);
            $table->integer("is_active")->default(0);
            $table->dateTime("created_at")->nullable();
            $table->dateTime("updated_at")->nullable();
            $table->dateTime("deleted_at")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('verification_configs');
    }
};
