<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vehicle_documents', function (Blueprint $table) {
            $table->id();
            $table->foreignId('rider_id');
            $table->foreignId('vehicle_id');
            $table->foreignId('config_id');
            $table->string('name');
            $table->longText('front_picture')->nullable();
            $table->longText('back_picture')->nullable();
            $table->text('field_title')->nullable();
            $table->text('field_input')->nullable();
            $table->integer("has_two_sides_image")->default(0);
            $table->string('status', 100)->default('pending'); //pending, approved, rejected, reupload
            $table->foreignId("handled_by")->nullable(); //staff id
            $table->dateTime("handled_at")->nullable();
            $table->dateTime("created_at")->nullable();
            $table->dateTime("updated_at")->nullable();
            $table->dateTime("deleted_at")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bike_verifications');
    }
};
