<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('riders', function (Blueprint $table) {
            $table->id();
            $table->string("uuid");
            $table->string("firstname");
            $table->string("lastname");
            $table->string("email")->nullable();
            $table->string("mobile");
            $table->string("password");
            $table->string('state', 100)->nullable();
            $table->string('city', 100)->nullable();
            $table->string("lat")->nullable();
            $table->string("lng")->nullable();
            $table->integer("rating")->default(0);
            $table->integer('wallet_balance')->default(0);
            $table->longText("avatar")->nullable();
            $table->string('paystack_customer_code')->nullable();
            $table->bigInteger("cancel_rate")->default(0);
            $table->string("expo_token")->nullable();
            $table->string("device_token")->nullable();
            $table->integer("is_booked")->default(0);
            $table->integer('is_mobile_verified')->default(0);
            $table->integer("is_online")->default(0);
            $table->integer("is_verified")->default(0);
            $table->integer('is_blocked')->default(0);
            $table->string('creation_ip_address')->nullable();
            $table->string('current_ip_address')->nullable();
            $table->string('creation_metadata')->nullable();
            $table->string('current_metadata')->nullable();
            $table->dateTime('last_login_date')->nullable();
            $table->dateTime("created_at")->nullable();
            $table->dateTime("updated_at")->nullable();
            $table->dateTime("deleted_at")->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bike_riders');
    }
};
