<?php

namespace App\Services;

use App\Helpers\SettingsHelper;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\File;

class TelegramService
{


    public function __construct() {}

    public function send_message($message)
    {
        try {
            $botToken = SettingsHelper::getValue("telegram", "bot_token");
            // $botToken = "8069210534:AAEmzdr6wAqYclavPqWqUYZhYoaTlpmZxlk";
            $chatId = SettingsHelper::getValue("telegram", "chat_id");

            if ($botToken && $chatId) {

                // dd($botToken);

                $url = "https://api.telegram.org/bot$botToken/sendMessage";
                $d = now()->format("Y-M-d h:i A");
                $postData = [
                    'chat_id' => $chatId,
                    // 'text' => $message
                    'text' => $message."\n\n $d"
                ];

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                $response = curl_exec($ch);
                curl_close($ch);

                // dd($response);
            }

            
        } catch (\Throwable $e) {
        }
    }
}
