<?php

namespace App\Services;

use App\Helpers\SettingsHelper;
use App\Models\Deposit;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\File;

use Carbon\Carbon;

use App\Models\User;

class NowpaymentService
{

    private $base_url;

    public function __construct()
    {
        $this->base_url = "https://api.nowpayments.io/v1";
    }

    public function create_invoice(Deposit $deposit)
    {
        try {
            $api_key = SettingsHelper::getValue("nowpayments", "api_key");

            $data = [
                'price_amount' => $deposit->amount,
                'price_currency' => $deposit->currency,
                'order_id' => $deposit->uuid,
                'order_description' => $deposit->uuid,
                'success_url' => route("verify.autopay", $deposit->uuid),
                'cancel_url' => route("verify.autopay", $deposit->uuid),
                'ipn_callback_url' => route("webhook.cryptomus"),
            ];

            $headers = [
                'accept' => 'application/json',
                'content-type' => 'application/json',
                'x-api-key' => $api_key,
            ];

            $response = Http::withHeaders($headers)->post("$this->base_url/invoice", $data);

            $rr = json_decode($response->body());


            if (!isset($rr->status)) {
                $result = $rr;

                $deposit->gateway_id = $result->token_id;
                $deposit->gateway_type = "nowpayments";
                $deposit->save();

                return $result->invoice_url;
            } else {
                return false;
            }
        } catch (\Throwable $e) {
            return false;
        }
    }

    public function create_payment(Deposit $deposit)
    {
        try {
            $api_key = SettingsHelper::getValue("nowpayments", "api_key");

            $data = [
                'price_amount' => $deposit->amount,
                'price_currency' => $deposit->currency,
                'pay_currency' => $deposit->method,
                'order_id' => $deposit->uuid,
                'order_description' => $deposit->uuid,
                'ipn_callback_url' => route("webhook.nowpayments"),
            ];

            $headers = [
                'accept' => 'application/json',
                'content-type' => 'application/json',
                'x-api-key' => $api_key,
            ];

            $response = Http::withHeaders($headers)->post("$this->base_url/payment", $data);

            $rr = json_decode($response->body());

            if (!isset($rr->status)) {
                $result = $rr;

                $deposit->gateway_id = $result->payment_id;
                $deposit->gateway_type = "nowpayments";
                $deposit->address = $result->pay_address;
                $deposit->save();

                return $result;
            } else {
                return false;
            }
        } catch (\Throwable $e) {
            return false;
        }
    }

    public function verify_payment(Deposit $deposit)
    {
        try {
            $api_key = SettingsHelper::getValue("nowpayments", "api_key");

            $headers = [
                'accept' => 'application/json',
                'content-type' => 'application/json',
                'x-api-key' => $api_key,
            ];

            $response = Http::withHeaders($headers)->get("$this->base_url/payment/$deposit->gateway_id");

            $rr = json_decode($response->body());

            if (!isset($rr->status)) {
                $result = $rr;
                if ($result->payment_status == 'finished') {
                    if ($deposit->is_confirmed == 0) {
                        if ($deposit->trader) {
                            $deposit->trader->balance = $deposit->trader->balance + $deposit->amount;
                            $deposit->trader->save();
                        }
                    }

                    $deposit->is_confirmed = 1;
                    $deposit->status = 'confirmed';
                }

                if ($result->payment_status == 'expired') {
                    $deposit->is_confirmed = 0;
                    $deposit->status = 'cancelled';
                }

                if ($result->payment_status == 'partially_paid') {
                    $deposit->is_confirmed = 0;
                    $deposit->status = 'wrong amount';
                }

                if ($result->payment_status == 'failed') {
                    $deposit->is_confirmed = 0;
                    $deposit->status = 'failed';
                }

                $deposit->save();

                return $result;
            } else {
                return false;
            }
        } catch (\Throwable $e) {
            return false;
        }
    }

    public function get_coins()
    {
        try {
            $api_key = SettingsHelper::getValue("nowpayments", "api_key");

            $headers = [
                'accept' => 'application/json',
                'content-type' => 'application/json',
                'x-api-key' => $api_key,
            ];

            $response = Http::withHeaders($headers)->get("$this->base_url/merchant/coins");

            $rr = json_decode($response->body());

            if (!isset($rr->status)) {
                $result = $rr;
                
                return $result->selectedCurrencies;
            } else {
                return false;
            }
        } catch (\Throwable $e) {
            return false;
        }
    }
}
