<?php

namespace App\Services;

use App\Helpers\SettingsHelper;
use App\Models\Deposit;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\File;

use Carbon\Carbon;

use App\Models\User;

class CryptomusService
{

    private $base_url;

    public function __construct()
    {
        $this->base_url = "https://api.cryptomus.com/v1";
    }

    public function create_invoice(Deposit $deposit)
    {
        try {
            $api_key = SettingsHelper::getValue("cryptomus", "api_key");
            $merchant_id = SettingsHelper::getValue("cryptomus", "merchant_id");

            $data = [
                'amount' => $deposit->amount,
                'currency' => $deposit->currency,
                'order_id' => $deposit->uuid,
                'url_success' => route("verify.autopay", $deposit->uuid),
                'url_return' => route("verify.autopay", $deposit->uuid),
                'url_callback' => route("webhook.cryptomus"),
                'lifetime' => 18000 //5 hours
            ];

            $datax = json_encode($data);
            $sign = md5(base64_encode($datax) . $api_key);

            $headers = [
                'accept' => 'application/json',
                'content-type' => 'application/json',
                'merchant' => $merchant_id,
                'sign' => $sign,
            ];

            $response = Http::withHeaders($headers)->post("$this->base_url/payment", $data);

            $rr = json_decode($response->body());
            
            // dd($rr);

            if ($rr->state == 0) {
                $result = $rr->result;
                $deposit->gateway_id = $result->uuid;
                $deposit->gateway_type = "cryptomus";
                $deposit->address = $result->address;
                $deposit->save();

                return $result->url;
            } else {
                return false;
            }
        } catch (\Throwable $e) {
            return false;
        }
    }

    public function verify_payment(Deposit $deposit)
    {
        try {
            $api_key = SettingsHelper::getValue("cryptomus", "api_key");
            $merchant_id = SettingsHelper::getValue("cryptomus", "merchant_id");

            $data = [
                'uuid' => $deposit->gateway_id,
                'order_id' => $deposit->uuid,
            ];

            $datax = json_encode($data);
            $sign = md5(base64_encode($datax) . $api_key);

            $headers = [
                'accept' => 'application/json',
                'content-type' => 'application/json',
                'merchant' => $merchant_id,
                'sign' => $sign,
            ];

            $response = Http::withHeaders($headers)->post("$this->base_url/payment", $data);

            $rr = json_decode($response->body());

            if ($rr->state == 0) {
                if ($rr->result->payment_status == 'paid' || $rr->result->payment_status == 'paid_over') {
                    if ($deposit->is_confirmed == 0) {
                        if ($deposit->trader) {
                            $deposit->trader->balance = $deposit->trader->balance + $deposit->amount;
                            $deposit->trader->save();
                        }
                    }

                    $deposit->is_confirmed = 1;
                    $deposit->status = 'confirmed';
                }

                if ($rr->result->payment_status == 'cancel') {
                    $deposit->is_confirmed = 0;
                    $deposit->status = 'cancelled';
                }

                if ($rr->result->payment_status == 'wrong_amount') {
                    $deposit->is_confirmed = 0;
                    $deposit->status = 'wrong amount';
                }

                if ($rr->result->payment_status == 'failed') {
                    $deposit->is_confirmed = 0;
                    $deposit->status = 'failed';
                }

                $deposit->save();

                return $deposit;
            } else {
                return false;
            }
        } catch (\Throwable $e) {
            return false;
        }
    }
}
