<?php

namespace App\Notifications;

use App\Notifications\Channels\ExpoNotificationChannel;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class TestNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable)
    {
        // return ['database'];
        return [ExpoNotificationChannel::class, 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
                    ->line('The introduction to the notification.')
                    ->action('Notification Action', url('/'))
                    ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            "title" => "Testing Laravel Notifications",
            "message" => "The toArray() is used by both the database broadcast channel. If you want to use both channels in the app with different array representations, you should define toDatabase() and toArray(). However, toArray() is the default."
        ];
    }

    public function toExpo(object $notifiable): array
    {
        return [
            "title" => "Testing Laravel Notifications Expo",
            "message" => "The toArray() is used by both the database broadcast channel. If you want to use both channels in the app with different array representations, you should define toDatabase() and toArray(). However, toArray() is the default."
        ];
    }

}
