<?php

namespace App\Notifications;

use App\Notifications\Channels\RiderFcmChannel;
use App\Notifications\Channels\WebPushChannel;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class StaffNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    protected $gchannels;
    public function __construct(
        public $title = null,
        public $message,
        public $link = null,
        public $data = [],
        public $channel = null,
    ) {
        $this->gchannels = [
            "webpush" => WebPushChannel::class,
            "database" => "database",
        ];

        $this->afterCommit();
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable)
    {

        if ($this->channel) {
            $cc = [];

            foreach ($this->channel as $k => $r) {
                if ($this->gchannels[$r]) {
                    array_push($cc, $this->gchannels[$r]);
                }
            }

            return $cc;
        }

        return [WebPushChannel::class, "database"];
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            "title" => $this->title,
            "message" => $this->message,
            "link" => $this->link,
            "data" => $this->data,
        ];
    }

    public function toWebPush(object $notifiable): array
    {
        return [
            "title" => $this->title,
            "message" => $this->message,
            "link" => $this->link,
            "data" => $this->data,
        ];
    }

    public function databaseType(object $notifiable): string
    {
        return 'staff-notification';
    }
}
