<?php

namespace App\Notifications\Channels;

use App\Services\ExpoService;
use Illuminate\Notifications\Notification;

class WebPushChannel
{
    /**
     * Send the given notification.
     */
    public function send(object $notifiable, Notification $notification): void
    {
        // dd($notifiable);
        $data = method_exists($notification, 'toWebPush')
            ? $notification->toWebPush($notifiable)
            : null;
        if (empty($data)) {
            return;
        }

        if ($notifiable->fcm_token) {
            (new ExpoService())->send_webpush($notifiable->fcm_token, $data['title'] ?? "", $data['message'] ?? "", $data['link'] ?? "", $data['data']);
        }

        return;

    }
}
