<?php

namespace App\Notifications\Channels;

use App\Services\ExpoService;
use Illuminate\Notifications\Notification;

class RiderFcmChannel
{
    /**
     * Send the given notification.
     */
    public function send(object $notifiable, Notification $notification): void
    {
        // dd($notifiable);
        $data = method_exists($notification, 'toExpo')
            ? $notification->toExpo($notifiable)
            : null;
        if (empty($data)) {
            return;
        }

        if($notifiable->device_token){
            (new ExpoService())->send_rider_notification($notifiable->device_token, $data['title'] ?? "", $data['message'] ?? "", ["abc" => 123]);
        }

    }
}
