<?php

namespace App\Models;

use App\Helpers\FilterHelper;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class UserId extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'user_ids';
    protected $guarded = [];

    protected $appends = ["front_url", "back_url"];

    public function user()
    {
        return $this->belongsTo(
            User::class,
        );
    }

    public function getFrontUrlAttribute()
    {
        if ($this->front) {
            return asset($this->front);
        }

        return null;
    }

    public function getBackUrlAttribute()
    {
        if ($this->back) {
            return asset($this->back);
        }

        return null;
    }
}
