<?php

namespace App\Models;

use App\Helpers\FilterHelper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TradePrediction extends Model
{
    use HasFactory;

    protected $table = 'trade_predictions';
    protected $guarded = [];
    protected $appends = [];

    public function user()
    {
        return $this->belongsTo(
            User::class,
        );
    }

    public function getFmtTradeActionAttribute()
    {
        return FilterHelper::formatTradeAction($this->trade_action);
    }

    public function getTradePlacedByAttribute()
    {
        if ($this->is_auto_trade) {
            return 'auto';
        }

        if ($this->source_id) {
            return 'copy';
        }

        return 'manual';
    }
}
