<?php

namespace App\Models;

use App\Helpers\FilterHelper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TradeBot extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'tradebots';
    protected $guarded = [];
    protected $appends = ["details_html", "avatar_url"];

    public function getDetailsHtmlAttribute()
    {
        if($this->details){
            $m = nl2br(htmlentities($this->details, ENT_QUOTES, 'UTF-8'));
            return FilterHelper::convertLinksAndEmails($m);
        }
        return null;
    }

    public function getAvatarUrlAttribute()
    {
        if($this->picture){
            return asset($this->picture);
        }
        else{
            return asset('/static/bot.png');
        }
    }

}
