<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Schema;
use DB;

class Site extends Model
{
    public static function convert_db_json_to_array($json)
    {
        $r = json_decode(json_encode(json_decode($json)), true);
        return $r;
    }

    public static function convert_db_array_to_json($arr)
    {
        $r = json_encode(json_decode(json_encode($arr)), true);
        return $r;
    }

    public static function send_email($email, $subject, $msg)
    {
        $logo = asset('/logo-dark.png');

        $message = "<!DOCTYPE html>
            <html lang='en' xmlns='http://www.w3.org/1999/xhtml' xmlns:o='urn:schemas-microsoft-com:office:office'>
            
            <head>
                <meta charset='utf-8'>
                <meta name='viewport' content='width=device-width,initial-scale=1'>
                <meta name='x-apple-disable-message-reformatting'>
               
                <!--[if mso]>
              <style>
                table {border-collapse:collapse;border-spacing:0;border:none;margin:0;}
                div, td {padding:0;}
                div {margin:0 !important;}
              </style>
              <noscript>
                <xml>
                  <o:OfficeDocumentSettings>
                    <o:PixelsPerInch>96</o:PixelsPerInch>
                  </o:OfficeDocumentSettings>
                </xml>
              </noscript>
              <![endif]-->
                <style>
                    table,
                    td,
                    div,
                    h1,
                    p {
                        font-family: Arial, sans-serif;
                    }
            
                    @media screen and (max-width: 530px) {
                        .unsub {
                            display: block;
                            padding: 8px;
                            margin-top: 14px;
                            border-radius: 6px;
                            background-color: #a9d7ea;
                            text-decoration: none !important;
                            font-weight: bold;
                        }
            
                        .col-lge {
                            max-width: 100% !important;
                        }
                    }
            
                    @media screen and (min-width: 531px) {
                        .col-sml {
                            max-width: 27% !important;
                        }
            
                        .col-lge {
                            max-width: 73% !important;
                        }
                    }
                </style>
            </head>
            
            <body style='margin:0;padding:0;word-spacing:normal;background-color:#f4f4f4;'>
                <div role='article' aria-roledescription='email' lang='en'
                    style='text-size-adjust:100%;-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%;background-color:#f4f4f4;'>
                    <table role='presentation' style='width:100%;border:none;border-spacing:0;'>
                        <tr>
                            <td align='center' style='padding:0;'>
                               
                                <table role='presentation'
                                    style='width:90%;max-width:600px;border:none;border-spacing:0;text-align:left;font-family:Arial,sans-serif;font-size:16px;line-height:1.8;color:#fff;'>
                                    <tr style='height: 30px;'>
                                        <td></td>
                                    </tr>
                                    
                                    <tr style='padding:0px 0px;background-color: #f4f4f4;'>
                                        <td style='padding:20px 30px 0px 30px;text-align:center;font-size:14px;font-weight:bold;'>
                                            
                                                <img src='$logo' width='50' alt=''
                                                style='text-decoration:none;color:#f4f4f4;'> 
                                           
                                        </td>
                                    </tr>
                                    
                                    <tr>
                                        <td style='padding:30px;background-color:#fff;color:#000;border-radius:30px;font-size:13px!important;'>
                                            $msg
                                           
                                        </td>
                                    </tr>
                                   
                                  
                                    
                                    <tr>
                                        <td
                                            style='padding-left:0px;text-align:left;font-size:12px;color:#000; background-color: #f4f4f4;'>
                                           
                                            <center><p>Copyright © 2025, All Rights Reserved.</p></center>
                                        </td>
                                    </tr>
                                  
                                </table>
                                <!--[if mso]>
                      </td>
                      </tr>
                      </table>
                      <![endif]-->
                            </td>
                        </tr>
                    </table>
                </div>
            </body>
            
            </html>
        ";

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

        $headers .= "X-Mailer: PHP/" . phpversion() . "\r\n";
        $headers .= "X-Priority: 1" . "\r\n";

        // More headers
        $headers .= "From: Blue Chip Growth Fund <support@bluechipcr.com>" . "\r\n";

        mail($email, $subject, $message, $headers);
    }
}
