<?php

namespace App\Models;

use App\Helpers\FilterHelper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Plan extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'plans';
    protected $guarded = [];
    protected $appends = ["options_html"];

    public function users()
    {
        return $this->hasMany(
            User::class,
        );
    }

    public function getOptionsHtmlAttribute()
    {
        if ($this->options) {
            $m = nl2br(htmlentities($this->options, ENT_QUOTES, 'UTF-8'));
            return FilterHelper::convertLinksAndEmails($m);
        }
        return null;
    }

}
