<?php

namespace App\Jobs;

use App\Models\User;
use App\Services\WalletService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessVirtualAccount implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(public User $user)
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        if($this->user->paystack_customer_code) {
            WalletService::create_virtual_account($this->user);
        }
        else {
            WalletService::create_customer($this->user);
            WalletService::create_virtual_account($this->user);
        }
    }
}
