<?php

namespace App\Jobs;

use App\Models\Rider;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessRiderAccountBalance implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(public Rider $rider)
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        $bal = $this->rider->account_balance();

        $this->rider->wallet_balance = $bal;
        $this->rider->save();
    }
}
