<?php

namespace App\Jobs;

use App\Events\CampaignDoneEvent;
use App\Models\Campaign;
use App\Models\Rider;
use App\Models\User;
use App\Notifications\RiderNotification;
use App\Notifications\UserNotification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\File;

class CampaignJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     */
    public function __construct(
        public $channel,
        public $records,
        public $campaign_id
    ) {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {

        $campaign = Campaign::find($this->campaign_id);

        if ($campaign) {

            if ($campaign->rule == "all_users") {
                $count = 0;
                foreach ($this->records as $r) {
                    if ($this->channel == "database") {
                        $r->notify(new UserNotification($campaign->title, $campaign->message, ['database']));
                    }

                    if ($this->channel == "expo") {
                        $r->notify(new UserNotification($campaign->title, $campaign->message, ['expo']));
                    }

                    if ($this->channel == "all") {
                        $r->notify(new UserNotification($campaign->title, $campaign->message, ['expo', 'database']));
                    }

                    $count++;
                }

                $campaign->total_done = $campaign->total_done + $count;
                $campaign->save();
            }

            if ($campaign->rule == "all_riders") {
                $count = 0;
                foreach ($this->records as $r) {
                    if ($this->channel == "database") {
                        $r->notify(new RiderNotification($campaign->title, $campaign->message, ['database']));
                    }

                    if ($this->channel == "expo") {
                        $r->notify(new RiderNotification($campaign->title, $campaign->message, ['expo']));
                    }

                    if ($this->channel == "all") {
                        $r->notify(new RiderNotification($campaign->title, $campaign->message, ['expo', 'database']));
                    }

                    $count++;
                }

                $campaign->total_done = $campaign->total_done + $count;
                $campaign->save();
            }

            if ($campaign->rule == "all_online_riders") {
                $count = 0;
                foreach ($this->records as $r) {
                    if ($this->channel == "database") {
                        $r->notify(new RiderNotification($campaign->title, $campaign->message, ['database']));
                    }

                    if ($this->channel == "expo") {
                        $r->notify(new RiderNotification($campaign->title, $campaign->message, ['expo']));
                    }

                    if ($this->channel == "all") {
                        $r->notify(new RiderNotification($campaign->title, $campaign->message, ['expo', 'database']));
                    }

                    $count++;
                }

                $campaign->total_done = $campaign->total_done + $count;
                $campaign->save();
            }

            if ($campaign->rule == "riders_with_cancel_rate") {
                $count = 0;
                foreach ($this->records as $r) {
                    if ($this->channel == "database") {
                        $r->notify(new RiderNotification($campaign->title, $campaign->message, ['database']));
                    }

                    if ($this->channel == "expo") {
                        $r->notify(new RiderNotification($campaign->title, $campaign->message, ['expo']));
                    }

                    if ($this->channel == "all") {
                        $r->notify(new RiderNotification($campaign->title, $campaign->message, ['expo', 'database']));
                    }

                    $count++;
                }

                $campaign->total_done = $campaign->total_done + $count;
                $campaign->save();
                
            }

            if($campaign->total_done >= $campaign->total_rows){
                $campaign->is_done = 1;
                $campaign->save();
                CampaignDoneEvent::dispatch($campaign);
            }
        }
    }
}
