<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\VendorResource;

class UserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return array_merge(parent::toArray($request), [
            "fullname" => $this->fullname,
            "trading_accounts" => $this->active_trading_accounts,
            "wallet_balance" => $this->wallet_balance,
            "avatar_url" => $this->avatar_url,
            "plan" => $this->plan,
            "twofa_code" => null,
            "kyc" => $this->ids()->orderBy("id", "DESC")->first(),
        ]);
    }
}
