<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AssetResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "symbol" => $this->symbol,
            "symbol_slash" => $this->symbol_slash,
            "market" => $this->market,
            "base_symbol" => $this->base_symbol,
            "quote_symbol" => $this->quote_symbol,
            "base_image_url" => $this->base_image_url,
            "quote_image_url" => $this->quote_image_url,
            "current" => $this->current,
            "low_point" => $this->low_point,
            "high_point" => $this->high_point,
            "amount" => $this->amount,
        ];
    }
}
