<?php

namespace App\Http\Controllers\Web\Current;

use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Models\RiderPayout;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;

use App\Models\User;
use App\Models\UserWalletTransaction;

class WebHookController extends Controller
{
    public function __construct() {}

    public function index(Request $request) {}

    public function cryptomus(Request $request)
    {
        // Retrieve the request's body
        $input = @file_get_contents("php://input");


        // $event = json_decode($input);
        $payload = json_decode($request->getContent(), true);
        if ($payload) {
            // user transfer
            if ($payload['type'] == 'payment') {
                $data = json_decode($payload, true);

                $deposit = Deposit::where("uuid", $payload->order_id)->first();
                if ($deposit) {

                    if ($data->status == 'paid' || $data->status == 'paid_over') {
                        if ($deposit->is_confirmed == 0) {
                            if ($deposit->trader) {
                                $deposit->trader->balance = $deposit->trader->balance + $deposit->amount;
                                $deposit->trader->save();
                            }
                        }

                        $deposit->is_confirmed = 1;
                        $deposit->status = 'confirmed';
                    }

                    if ($data->status == 'cancel') {
                        $deposit->is_confirmed = 0;
                        $deposit->status = 'cancelled';
                    }

                    if ($data->status == 'wrong_amount') {
                        $deposit->is_confirmed = 0;
                        $deposit->status = 'wrong amount';
                    }

                    if ($data->status == 'failed') {
                        $deposit->is_confirmed = 0;
                        $deposit->status = 'failed';
                    }

                    $deposit->save();
                }
            }
        }
    }
}
