<?php

namespace App\Http\Controllers\Web\Current\Admin;

use App\Helpers\SettingsHelper;
use App\Http\Controllers\Controller;
use App\Models\Deposit;
use App\Models\PaymentSettings;
use App\Models\Plan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

use App\Models\Staff;
use App\Models\User;
use App\Models\Withdrawal;

class DashboardController extends Controller
{
    public function __construct() {}

    public function index(Request $request)
    {
        $total_users = User::all()->count();
        $total_deposits = Deposit::sum('amount');
        $total_withdrawals = Withdrawal::sum('amount');

        return view('admin.dashboard', [
            'page_title' => "Dashboard",
            "total_users" => $total_users,
            "total_deposits" => $total_deposits,
            "total_withdrawals" => $total_withdrawals,
        ]);
    }

    public function deposits(Request $request)
    {
        return view('admin.deposits', [
            'page_title' => "All Deposits",
        ]);
    }

    public function withdrawals(Request $request)
    {
        return view('admin.withdrawals', [
            'page_title' => "All Withdrawals",
        ]);
    }

    public function crypto_payment_settings($user_id, Request $request)
    {
        $user = User::find($user_id);

        if (isset($_POST['create_payment'])) {
            $this->validate($request, [
                'name' => 'required',
                'address' => 'required',
            ]);

            $record = PaymentSettings::where("name", $request->name)->first();

            if ($record) {
                return back()->with("error", "payment already exist");
            } else {
                PaymentSettings::create([
                    "user_id" => $user?->id,
                    "name" => $request->name,
                    "address" => $request->address,
                ]);

                return back()->with("success", "Record Added");
            }
        }

        if (isset($_POST['edit_payment'])) {
            $this->validate($request, [
                'c_id' => 'required',
                'name' => 'required',
                'address' => 'required',
            ]);

            $check = PaymentSettings::where("name", $request->name)->where("id", "!=", $request->c_id)->first();

            if ($check) {
                return back()->with("error", "payment already exist");
            } else {

                $record = PaymentSettings::find($request->c_id);

                $record->name = $request->name;
                $record->address = $request->address;
                $record->save();

                return back()->with("success", "Record Updated");
            }
        }

        if (isset($_POST['delete_payment'])) {
            $this->validate($request, [
                'c_id' => 'required',
            ]);

            $record = PaymentSettings::find($request->c_id);

            if ($record) {
                $record->delete();
                return back()->with("success", "Record Deleted");
            } else {
                return back()->with("error", "Record not Found");
            }
        }

        if ($user) {
            $settings = PaymentSettings::where("user_id", $user->id)->get();
        } else {
            $settings = PaymentSettings::orderBy("id", "DESC")->get();
        }

        return view('admin.crypto_settings', [
            'page_title' => $user ? "$user->fullname Crypto Payment Methods" : "All Crypto Payment Methods",
            "settings" => $settings
        ]);
    }

    public function plans(Request $request)
    {
        if (isset($_POST['create_plan'])) {
            $this->validate($request, [
                'title' => 'required',
                'options' => 'required',
            ]);

            $record = Plan::where("title", $request->title)->first();

            if ($record) {
                return back()->with("error", "Plan already exist");
            } else {
                Plan::create([
                    "title" => $request->title,
                    "options" => $request->options,
                ]);

                return back()->with("success", "Record Added");
            }
        }

        if (isset($_POST['edit_plan'])) {
            $this->validate($request, [
                'c_id' => 'required',
                'title' => 'required',
                'options' => 'required',
            ]);

            $check = Plan::where("title", $request->title)->where("id", "!=", $request->c_id)->first();

            if ($check) {
                return back()->with("error", "already exist");
            } else {

                $record = Plan::find($request->c_id);
                if ($record) {

                    $record->title = $request->title;
                    $record->options = $request->options;
                    $record->save();
                }

                return back()->with("success", "Record Updated");
            }
        }

        if (isset($_POST['delete_plan'])) {
            $this->validate($request, [
                'c_id' => 'required',
            ]);

            $record = Plan::find($request->c_id);

            if ($record) {
                $record->delete();
                return back()->with("success", "Record Deleted");
            } else {
                return back()->with("error", "Record not Found");
            }
        }


        $plans = Plan::orderBy("id", "DESC")->get();

        return view('admin.plans', [
            'page_title' => "Plans",
            'plans' => $plans,
        ]);
    }

    public function settings_payment(Request $request)
    {
        $current_crypto_gateway = SettingsHelper::getObj(null, "current_crypto_gateway");
        $nowpayments_api_key = SettingsHelper::getObj("nowpayments", "api_key");

        if (isset($_POST['update_settings'])) {
            $this->validate($request, [
                'nowpayments_api_key' => 'required',
                'current_crypto_gateway' => 'required',
            ]);

            if ($current_crypto_gateway) {
                $current_crypto_gateway->value = $request->current_crypto_gateway;
                $current_crypto_gateway->save();
            }

            if ($nowpayments_api_key) {
                $nowpayments_api_key->value = $request->nowpayments_api_key;
                $nowpayments_api_key->save();
            }

            return back()->with("success", "Record Updated");
        }

        return view('admin.settings_payment', [
            'page_title' => "Deposit Payment Settings",
            'current_crypto_gateway' => $current_crypto_gateway?->value,
            'nowpayments_api_key' => $nowpayments_api_key?->value,
        ]);
    }

    public function settings(Request $request)
    {
        $bot_token = SettingsHelper::getObj("telegram", "bot_token");
        $chat_id = SettingsHelper::getObj("telegram", "chat_id");

        if (isset($_POST['update_settings'])) {
            $this->validate($request, [
                // 'bot_token' => 'required',
                // 'chat_id' => 'required',
            ]);

            if ($chat_id) {
                $chat_id->value = $request->chat_id;
                $chat_id->save();
            }

            if ($bot_token) {
                $bot_token->value = $request->bot_token;
                $bot_token->save();
            }

            return back()->with("success", "Record Updated");
        }

        return view('admin.settings', [
            'page_title' => "Settings",
            'bot_token' => $bot_token?->value,
            'chat_id' => $chat_id?->value,
        ]);
    }
}
