<?php

namespace App\Http\Controllers\Web\Current\Admin;

use App\Helpers\FilterHelper;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

use App\Models\User;
use App\Models\Asset;
use App\Models\Market;

class AssetController extends Controller
{

    public function __construct() {}

    public function index(Request $request)
    {
        if ($request->has('delete_asset')) {
            $validator = Validator::make($request->all(), [
                "c_id" => "required",
            ]);

            if ($validator->fails()) {
                return redirect()
                    ->back()
                    ->with($validator->messages()->first());
            } else {

                $record = Asset::find($request->c_id);
                if ($record) {
                    $record->delete();

                    return redirect()
                        ->back()
                        ->with('Done');
                }
            }
        }

        if ($request->has('create_asset')) {
            $validator = Validator::make($request->all(), [
                "base_symbol" => "required",
                "market" => "required",
                "current_price" => "required",
            ]);

            if ($validator->fails()) {
                return back()
                    ->with("error", $validator->messages()->first());
            } else {

                $ast = new Asset();
                $ast->base_symbol = strtolower($request->base_symbol);
                $ast->quote_symbol = $request->quote_symbol ? strtolower($request->quote_symbol) : null;
                $ast->symbol = strtolower($request->base_symbol) . '' . strtolower($request->quote_symbol);
                $ast->market = strtolower($request->market);
                $ast->amount = 10;
                $ast->current = FilterHelper::amount($request->current_price);
                $ast->save();

                return redirect()
                    ->back()
                    ->with('Done');
            }
        }

        if ($request->has('edit_asset')) {
            $validator = Validator::make($request->all(), [
                "c_id" => "required",
                "base_symbol" => "required",
                "market" => "required",
                "current_price" => "required",
            ]);

            if ($validator->fails()) {
                return back()
                    ->with("error", $validator->messages()->first());
            } else {

                $ast = Asset::find($request->c_id);
                if ($ast) {
                    $ast->base_symbol = strtolower($request->base_symbol);
                    $ast->quote_symbol = $request->quote_symbol ? strtolower($request->quote_symbol) : null;
                    $ast->market = strtolower($request->market);
                    $ast->amount = 10;
                    $ast->current = FilterHelper::amount($request->current_price);
                    $ast->save();
                }

                return redirect()
                    ->back()
                    ->with('success', 'Done');
            }
        }

        $assets = Asset::orderBy("id", "desc")->get();
        $markets = Market::orderBy("id", "desc")->get();

        return view("admin.assets", [
            "page_title" => 'Assets',
            "assets" => $assets,
            "markets" => $markets,
        ]);
    }
}
