<?php

namespace App\Enums;

enum TripStatus: string
{
    case INIT = 'init';
    case SEARCH_RIDER = 'search_rider';
    case SHOW_RIDER = 'show_rider';
    case RIDER_ACCEPTED = 'rider_accepted';
    case RIDER_ARRIVED = 'rider_arrived';
    case ONTRIP = 'ontrip';
    case ARRIVED_AT_DESTINATION = 'arrived_at_destination';
    case COMPLETED = 'completed';
    case CANCELLED = 'cancelled';
    case HOLD = 'hold';

    public static function toArray(): array
    {
        $cases = [];

        foreach (self::cases() as $case) {
            $cases[$case->name] = $case->value;
        }

        return $cases;
    }

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }
}
