<?php

namespace App\Enums;

enum StaffRole: string
{
    case SUPERADMIN   = 'superadmin';
    case ADMIN        = 'manager';
    case SUPERVISOR   = 'supervisor';
    case SUPPORT      = 'support';
    case FINANCE      = 'finance';

    public static function toArray(): array
    {
        $cases = [];

        foreach (self::cases() as $case) {
            $cases[$case->name] = $case->value;
        }

        return $cases;
    }

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }
}
